function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = World_Economy_Cartel_IRF.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(62, 1);
residual(1) = T(29)+T(32)+params(21)*y(108)-y(75);
residual(2) = T(24)*(-exp(y(23)))+y(68)*(-(T(28)*params(4)*exp(y(23)*params(4))))+exp(y(23))*y(58)+params(21)*y(110)-y(77);
residual(3) = y(67)*(-(T(27)*params(4)*exp(y(24)*params(4))))+y(63)*y(35)*T(27)*params(4)*(params(4)-1)*exp(y(24)*(params(4)-1))+exp(y(24))*y(58)+params(21)*y(109)-y(76);
residual(4) = T(24)*T(33)+y(71)*(-exp(y(25)))+exp(y(25))*y(70)+params(21)*y(112)-y(79);
residual(5) = y(71)*(-exp(y(26)))+exp(y(26))*y(69)+params(21)*y(111)-y(78);
residual(6) = T(35);
residual(7) = T(37);
residual(8) = T(38);
residual(9) = T(39);
residual(10) = T(41)+params(21)*y(107)*(-exp(y(31)));
residual(11) = T(36)+y(64)*T(42)+y(61)*T(43)+params(21)*y(98)*exp(y(28))*params(6)*params(5)*exp(params(5)*y(32))+T(44);
residual(12) = exp(y(33))*y(57);
residual(13) = y(62)*(-params(7))+y(61)+T(30)*y(18)*(-(exp(y(43))*(1-exp(y(11)))))+T(30)*exp(y(43))*y(20);
residual(14) = params(4)*exp(y(24)*(params(4)-1))*T(27)*y(63)+y(62)+T(30)*y(19)*(-(exp(y(43))*(1-params(7))));
residual(15) = T(8)*y(71)+y(54)*(-(params(11)*T(12)*T(45)))+y(53)*(-(params(11)*T(46)*T(47)));
residual(16) = y(58)*(-exp(y(37)))+y(56)*(-(T(5)*T(19)*T(16)*T(49)))+y(55)*(-(T(17)*T(3)*T(16)*T(50)))+y(54)*(-(T(14)*params(11)*T(48)))+exp(y(37))*y(53)+params(21)*y(113)-y(80);
residual(17) = T(20)*y(58)+params(21)*y(94)*(-(T(57)*T(60)))+params(21)*y(95)*(-(T(61)*(T(53)*T(63)*T(64)+T(54)*T(63)*T(66))))+params(21)*y(96)*T(70)+params(21)*y(97)*(-(exp((1-params(3))*y(88))*exp(T(1)*y(92))*params(3)*exp(params(3)*y(38))))+params(21)*y(98)*(-(T(20)*(1-params(10))));
residual(18) = (T(33)-exp(y(23)))*T(74)+y(60)*(-(params(1)*T(74)/T(26)))+T(4)*y(59)+y(57)*T(76)+y(56)*T(80)+y(55)*T(82)+y(53)*(-(T(47)*T(84)))+params(21)*y(99)*(-((-(T(74)*T(86)))/(T(24)*T(24))));
residual(19) = (T(33)-exp(y(23)))*T(87)+y(60)*T(88)+exp(y(40))*y(58)+params(21)*y(99)*(-((-(T(86)*T(87)))/(T(24)*T(24))));
residual(20) = exp(y(41))*y(56)+T(89);
residual(21) = y(59)*(-(T(21)*T(90)))+exp(y(42))*y(55);
residual(22) = T(91);
residual(23) = y(73)+params(21)*y(106)*(-params(15))+y(57)*(-(exp(y(39)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(44))))+y(56)*(-(T(5)*T(19)*T(16)*T(92)))+y(55)*(-(T(17)*T(3)*T(16)*T(93)))+y(53)*(-(T(47)*T(95)))+T(96)*(-params(16))*y(114);
residual(24) = T(99)+y(72)+T(103);
residual(25) = y(75);
residual(26) = y(76);
residual(27) = y(77);
residual(28) = y(78);
residual(29) = y(79);
residual(30) = y(80);
residual(31) = T(24)*T(104)+exp(y(52))*y(74);
residual(32) = exp(y(37))-T(9)^T(10);
residual(33) = exp(y(22))-params(11)*T(12)*T(14);
residual(34) = exp(y(42))-T(3)*T(15)*T(16)*T(17);
residual(35) = exp(y(41))-T(5)*T(16)*T(18)*T(19);
residual(36) = exp(y(33))-exp(T(1)*y(44))*exp(y(13)*params(3))*exp(y(39)*(1-params(3)));
residual(37) = exp(y(40))+T(20)+exp(y(24))+exp(y(23))+params(6)*exp(params(5)*y(11))*exp(y(7))+params(6)*exp(params(5)*(y(10)-y(45)))*exp(y(6))-(exp(y(37))+exp(y(13))*(1-params(10)));
residual(38) = T(4)-T(21)*exp(y(42))^T(22);
residual(39) = 1-exp(y(91))*(1+exp(y(90))-params(10));
residual(40) = exp(y(43))-params(1)*T(24)/T(26);
residual(41) = y(34)-exp(y(91))*(exp(y(32))*exp(y(83))+(1-exp(y(32)))*y(84)-params(6)*exp(params(5)*y(32)));
residual(42) = y(35)-(y(34)*params(7)+exp(y(91))*(1-params(7))*y(85));
residual(43) = y(35)*params(4)*exp(y(24)*(params(4)-1))*T(27)-1;
residual(44) = T(105);
residual(45) = exp(y(28))-(exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(30)));
residual(46) = exp(y(27))-(exp(y(6))*(1-exp((-y(45)))*exp(y(10)))+params(7)*exp(y(29)));
residual(47) = exp(y(30))-((1-params(7))*exp(y(9))+T(27)*exp(y(24)*params(4)));
residual(48) = exp(y(29))-((1-params(7))*exp(y(8))+exp(y(23)*params(4))*T(28));
residual(49) = exp(y(26))-exp(y(7))*exp(y(11));
residual(50) = exp(y(25))-exp(y(6))*exp((-y(45)))*exp(y(10));
residual(51) = T(8)-(exp(y(26))+exp(y(25)));
residual(52) = y(45)-x(it_, 1);
residual(53) = y(44)-(x(it_, 2)+params(15)*y(16)+params(16)*y(21));
residual(54) = exp(y(52))-exp(y(10));
residual(55) = y(46)-(y(22)-y(1));
residual(56) = y(47)-(y(24)-y(3));
residual(57) = y(48)-(y(23)-y(2));
residual(58) = y(49)-(y(26)-y(5));
residual(59) = y(50)-(y(25)-y(4));
residual(60) = y(51)-(y(37)-y(12));
lhs = y(81);
rhs = y(106);
residual(61) = lhs - rhs;
lhs = y(82);
rhs = y(16);
residual(62) = lhs - rhs;

end
